﻿//If the Btsss root namespace object isn’t defined, create it.
if (typeof (Btsss) == "undefined")
{ Btsss = {}; }

// Create Namespace container for architectural area of this library
// only if it isn’t already defined in another JavaScript file
if (typeof (Btsss.Crm) == "undefined")
{ Btsss.Crm = {}; }

if (typeof (Btsss.Crm) == "undefined")
{ Btsss.Crm.Configuration = {}; }

// Define the layer or class 
Btsss.Crm.Configuration = {
    getFacilities: function (context) {
        var req = new XMLHttpRequest();
        req.open("GET", Xrm.Page.context.getClientUrl() + "/api/data/v8.1/btsss_facilities?$select=btsss_facilityid", true);
        req.setRequestHeader("OData-MaxVersion", "4.0");
        req.setRequestHeader("OData-Version", "4.0");
        req.setRequestHeader("Accept", "application/json");
        req.setRequestHeader("Prefer", "odata.include-annotations=\"*\"");
        req.onreadystatechange = function () {
            if (this.readyState === 4) {
                req.onreadystatechange = null;
                if (this.status === 200) {
                    var results = JSON.parse(this.response);
                } else {
                    Xrm.Utility.alertDialog(this.statusText);
                }
            }
        };
        req.send();
    },
    getTeams: function(){
        var req = new XMLHttpRequest();
        req.open("GET", Xrm.Page.context.getClientUrl() + "/api/data/v8.1/teams?$select=_administratorid_value,_businessunitid_value,isdefault,systemmanaged,teamid&$filter=isdefault eq false and  systemmanaged eq false", true);
        req.setRequestHeader("OData-MaxVersion", "4.0");
        req.setRequestHeader("OData-Version", "4.0");
        req.setRequestHeader("Accept", "application/json");
        req.setRequestHeader("Content-Type", "application/json; charset=utf-8");
        req.setRequestHeader("Prefer", "odata.include-annotations=\"*\"");
        req.onreadystatechange = function () {
            if (this.readyState === 4) {
                req.onreadystatechange = null;
                if (this.status === 200) {
                    var results = JSON.parse(this.response);
                    for (var i = 0; i < results.value.length; i++) {
                        var _administratorid_value = results.value[i]["_administratorid_value"];
                        var _administratorid_value_formatted = results.value[i]["_administratorid_value@OData.Community.Display.V1.FormattedValue"];
                        var _administratorid_value_lookuplogicalname = results.value[i]["_administratorid_value@Microsoft.Dynamics.CRM.lookuplogicalname"];
                        var _businessunitid_value = results.value[i]["_businessunitid_value"];
                        var _businessunitid_value_formatted = results.value[i]["_businessunitid_value@OData.Community.Display.V1.FormattedValue"];
                        var _businessunitid_value_lookuplogicalname = results.value[i]["_businessunitid_value@Microsoft.Dynamics.CRM.lookuplogicalname"];
                        var isdefault = results.value[i]["isdefault"];
                        var isdefault_formatted = results.value[i]["isdefault@OData.Community.Display.V1.FormattedValue"];
                        var systemmanaged = results.value[i]["systemmanaged"];
                        var systemmanaged_formatted = results.value[i]["systemmanaged@OData.Community.Display.V1.FormattedValue"];
                        var teamid = results.value[i]["teamid"];
                    }
                } else {
                    Xrm.Utility.alertDialog(this.statusText);
                }
            }
        };
        req.send();
    },
    setTeamAdministrator: function()
    {
        var parameters = {};
        parameters.Teams = "Collection(mscrm.crmbaseentity) Not Handled";
        var parameters = {
            "Teams"://EntityCollection parameter
              [
                   {
                       "@odata.type": "Microsoft.Dynamics.CRM.account",//entity type
                       "accountid": "C4CA0B66-59B9-E611-8106-C4346BDC0E01",//Record's guid
                       "name": "Test",//name field of the account entity
                       "accountnumber": "123"//accountnumber field of the account entity
                   },
                   {
                       "@odata.type": "Microsoft.Dynamics.CRM.account",
                       "accountid": "CD67D78E-16BB-E611-8109-C4346BDC3C21",
                       "name": "Test2",
                       "accountnumber": "1234"
                   }
              ]
        };
        var req = new XMLHttpRequest();
        req.open("POST", Xrm.Page.context.getClientUrl() + "/api/data/v8.1/teams()/Microsoft.Dynamics.CRM.new_SetTeamAdministrator", true);
        req.setRequestHeader("OData-MaxVersion", "4.0");
        req.setRequestHeader("OData-Version", "4.0");
        req.setRequestHeader("Accept", "application/json");
        req.setRequestHeader("Content-Type", "application/json; charset=utf-8");
        req.onreadystatechange = function () {
            if (this.readyState === 4) {
                req.onreadystatechange = null;
                if (this.status === 204) {
                    //Success - No Return Data - Do Something
                } else {
                    Xrm.Utility.alertDialog(this.statusText);
                }
            }
        };
        req.send(JSON.stringify(parameters));
    }
};
